#pragma rtGlobals=1		// Use modern global access method.
#include "IR1_Loader"
menu "Plot&fit"
	"-"
	Submenu "Major Tools"
		"Background Subtraction Tool/2",DWS_DataManipulationPanel()
	end
end

Function DWS_DataManipulationPanel()
		IN2G_CheckScreenSize("height",670)
	DoWindow DWS_DataManipulationPanel
	if(V_Flag)
		DoWindow/K DWS_DataManipulationPanel
	endif
	IR1D_InitDataManipulation()
		
	if (!DataFolderExists("root:Packages:BackgoundSubtrationTool"))		//create folder for background
		NewDataFolder/O root:Packages:BackgoundSubtrationTool
	endif
	setdatafolder root:Packages:SASDataModification
	variable/g Data1_Thickness
	make/o/N=2 xavedata,yavedata
	xavedata={ .001, .1}
	yavedata={ 1e4, 1}
	PlotData("yavedata","xavedata", "")
end

function Plotdata(rwavename,qwavename, text)
	string rwavename,qwavename, text
	wave rwave=$rwavename
	wave qwave=$qwavename			
	NVAR UseIndra2Data=root:Packages:SASDataModification:UseIndra2Data
	NVAR UseQRSData=root:Packages:SASDataModification:UseQRSdata
	NVAR Data1_Thickness=root:Packages:SASDataModification:Data1_Thickness
	UseQRSdata=0
	UseIndra2Data=1
	variable thickness
	Data1_Thickness=thickness
	dowindow/K BackgroudSubtractTool
	Display/K=1/N=BackgroudSubtractTool/W=(50, 50, 300, 300 ) rwave vs qwave
	ModifyGraph font="arial", width=350, height=300, lblMargin(left)=6
	DoWindow /T LQD, "BackgroudSubtractTool"
	ControlBar /T 310
	

	String PanelWindowName="BackgroudSubtractTool"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes=""//"SizesNumberDistribution;SizesVolumeDistribution;"
	String AllowedUserTypes=""//"*_par;" or "r*;"	
	String UserNameString=""//"*_par" or "qrs"
	String XUserTypeLookup=""//"r*:q*;"	
	String EUserTypeLookup=""//"s*;"
	String   PckgDataFolder= "SASDataModification"
		//String PckgDataFolder="BackgroudSubtractTool"
	variable RequireErrorWaves=0
	variable  AllowModelData=0	
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)	
	MoveSelectionTools(2,2)
Variable YPOS =130
	Button Plotdata,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DataManipulationButtonProc,title="PlotDATA"		
	Button RemoveTrace,pos={100,YPOS},size={65,16},font="Times New Roman",fSize=10,proc=DWS_DataManipulationButtonProc,title="RemoveTrace"	
	Button PowerLawButton,pos={220,YPOS},size={100,16},font="Times New Roman",fSize=10,proc=DWS_DataManipulationButtonProc,title="Subtract PowerLaw"
YPOS=150//Data Selection


	Button AverageCursors,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DataManipulationButtonProc,title="AveCsrs"
	Button Subtract,pos={160,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DataManipulationButtonProc,title="Subtract avg"
	SetVariable Data1_Background, pos={65,YPOS}, size={80,20},title="avg", proc=DWS_setvarDataManip
	SetVariable Data1_Background, value= root:Packages:SASDataModification:Data1_Background
	
YPOS=183//Background Selections

	PopupMenu SelectDataFolder2,pos={8,YPOS},size={100,15},fSize=10,proc=IR1D_PanelPopupControl,title="Bkg:", help={"Background"}
	PopupMenu SelectDataFolder2,mode=1,popvalue="---",value= #"\"---;\"+IR1_GenStringOfFolders(root:Packages:SASDataModification:UseIndra2Data, root:Packages:SASDataModification:UseQRSData,2,1)"
	PopupMenu QvecDataName2,pos={9,YPOS+25},size={25,15},fSize=10,proc=IR1D_PanelPopupControl,title="Q"
	PopupMenu QvecDataName2,mode=1,popvalue="---",value= #"\"---;\"+IR1_ListOfWaves(\"DSM_Qvec\",\"BackgroudSubtractTool\",1)"
	PopupMenu IntensityDataName2,pos={8,YPOS+50},size={100,15},fSize=10,proc=IR1D_PanelPopupControl,title="R"
	PopupMenu IntensityDataName2,mode=1,popvalue="---",value= #"\"---;\"+IR1_ListOfWaves(\"DSM_Int\",\"BackgroudSubtractTool\",1)"
	PopupMenu ErrorDataName2,pos={10,YPOS+75},size={100,21},fSize=10,proc=IR1D_PanelPopupControl,title="S"
	PopupMenu ErrorDataName2,mode=1,popvalue="---",value= #"\"---;\"+IR1_ListOfWaves(\"DSM_Error\",\"BackgroudSubtractTool\",1)"
YPOS+=100
	Button PlotBkg,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DataManipulationButtonProc,title="Plot Bkg"	
	Button SubtractBkg,pos={65,YPOS},size={80,16},font="Times New Roman",fSize=10,proc=DWS_DataManipulationButtonProc,title="Subtract Bkg"	
	Button RestoreRwave,pos={150,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_DataManipulationButtonProc,title="Restore"

	TextBox/C/N=text0/A=MC text
	ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
	ModifyGraph grid=2,mirror=1,minor(bottom)=1,fStyle=1,fSize=18,logLabel(left)=0
	ModifyGraph font="arial", width=350, height=300, lblMargin(left)=6
	ModifyGraph rgb($rwavename)=(0,0,0),mode($rwavename)=3
	Label left "\\Z18\\f01\\F'arial'Intensity (cm\\S-1\\M\\Z18\\f01)"
	Label bottom "\\Z18\\f01\\F'arial'q (A\\S-1\\M\\Z18\\f01)"
	string n=num2str(numpnts(rwave))
	execute("cursor b,"+rwavename+","+n)
	n=num2str(numpnts(rwave)-10)
	execute("cursor a,"+rwavename+","+n)
	ShowInfo
	textBox/K/N=text0
end

Proc DWS_FitPowerLawWithCursors()
	string olddf=GetDataFolder(1)	
	if (!DataFolderExists("root:Packages:FittingData:"))
		NewDataFolder root:Packages:FittingData		//create Desmear folder, if it does not exist
	endif
	setDataFolder root:Packages:FittingData	
	Make/D/O/N=(numpnts($(getWavesDataFolder(CsrWaveRef(A),2)))) LogYFitData
	Make/D/O/N=(numpnts($(getWavesDataFolder(CsrXWaveRef(A),2)))) LogXFitData
	LogXFitData=log($(getWavesDataFolder(CsrXWaveRef(A),2)))
	LogYFitData=log($(getWavesDataFolder(CsrWaveRef(A),2)))
	CurveFit line LogYFitData(xcsr(A),xcsr(B)) /X=LogXFitData 
	killwaves LogXFitData,LogYFitData	
	setdatafolder olddf
end

Function DWS_DataManipulationButtonProc(ctrlName) : ButtonControl
	String ctrlName
	SVAR BKGFolder=root:Packages:SASDataModification:DataFolderName2
	SVAR BKGIntensityWavename=root:Packages:SASDataModification:IntensityWaveName2
	SVAR BKGQWavename=root:Packages:SASDataModification:QWavename2	
	SVAR foldername=    root:Packages:SASDataModification:DataFolderName
	SVAR Rwavename=root:Packages:SASDataModification:IntensityWaveName
	SVAR Qwavename=root:Packages:SASDataModification:QWavename	
	SVAR SWaveName=root:Packages:SASDataModification:ErrorWaveName			
	NVAR Data1_Background=root:Packages:SASDataModification:Data1_Background
	NVAR Data1_IntMultiplier=root:Packages:SASDataModification:Data1_IntMultiplier	
	NVAR Data1_Thickness=root:Packages:SASDataModification:Data1_Thickness	
	string thefolder,thetext="",list,n,tracename
	variable counter = 0,NumberofWaves,background,start
	string wavenote, cmd
	setdatafolder BKGFolder
		wave BKGIntensityWave=$replacestring("'",BKGIntensityWavename,"")
		wave BkgQWave=$replacestring("'",BKGQWavename,"")
	if (datafolderexists(foldername))
		setdatafolder foldername		
		wave RWave=$Rwavename
		wave QWave=$Qwavename
		wave SWave=$Swavename
	endif
	NVAR qshift=root:Packages:SASDataModification:qshift	
	string  newRwavename,newQwavename,newSwavename
		
	IF(cmpstr(ctrlName,"PowerLawButton")==0)
		Execute ("DWS_FitPowerLawWithCursors()")
			newRwavename=rwavename+"_P"
		 	newRwavename=foldername+possiblyquotename(newrwavename)//for powerlaww subtraction
			duplicate/o $Rwavename,$newRwavename
			wave newrwave=$newRwavename
			
			newQwavename=Qwavename+"_P"
		 	 newQwavename=foldername+possiblyquotename(newQwavename)//for powerlaww subtraction
			duplicate/o $Qwavename,$newQwavename
			wave newQwave=$newQwavename
						
			if (waveexists($Swavename))			
				newSwavename=Swavename+"_P"
		 		newSwavename=foldername+possiblyquotename(newSwavename)//for powerlaww subtraction
				duplicate/o $Swavename,$newSwavename
				wave newSwave=$newSwavename
			endif
		wave W_coef=root:Packages:FittingData:W_coef
		newrwave=rwave-(10^W_coef[0])*qwave^W_coef[1]
		appendtograph newrwave vs newqwave		
	endif	
	
	
	IF(cmpstr(ctrlName,"RemoveTrace")==0)
		string tracelist=TraceNameList("BackgroudSubtractTool", ";", 1 )
		 tracename=StringFromList(0, tracelist,";")
		If (!stringmatch(tracename, "" ))
			tracename=StringFromList(1, tracelist,";")
			RemoveFromGraph $tracename
		else
			Legend/K/N=text1
			string boxname="CF_"+Rwavename
			TextBox/K/N=$boxname
		endif
		Legend/K/N=text1
	endif

	IF(cmpstr(ctrlName,"AverageCursors")==0)
			setdatafolder FolderName
		Wave w = CsrWaveRef(A)
		wave ww=CsrWaveRef(B)
		setdatafolder BKGfolder	
		if ((!WaveExists(w))||(!WaveExists(ww)))
			Doalert 0, "Cursor is not on graph"
			abort
		endif			
		WaveStats/r=[pcsr(A,"BackgroudSubtractTool"),pcsr(B,"BackgroudSubtractTool")]w
		Background=V_avg
		Data1_Background=Background
		Data1_IntMultiplier=1/Background
		setdatafolder root:Packages:SASDataModification
		make/o/N=2 xavedata,yavedata
		yavedata=Background
		 wave q = CsrXWaveRef(A  ,"BackgroudSubtractTool")
		xavedata={ q(pcsr(A,"BackgroudSubtractTool")), q[pcsr(B,"BackgroudSubtractTool")]}
		appendtograph  yavedata vs xavedata///n="IR1D_DataManipulationGraph"
		ModifyGraph lsize(yavedata)=3,rgb(yavedata)=(0,0,0)
	endif
	
	
	IF(cmpstr(ctrlName,"PlotData")==0)		
		setdatafolder  FolderName
		Appendtograph RWave vs QWave	
		list=TraceNameList("",";",1)
		NumberofWaves=ItemsInList(tracenamelist("",";",1))
		n="2"//=num2str(numpnts(RWave))
		string nn="20"//num2str(numpnts(RWave)-20)
		nn="15"
		execute("cursor b,"+PossiblyQuoteName(RWaveName )+","+n)	
		execute("cursor a,"+PossiblyQuoteName(RWaveName )+","+nn)
		Legend/C/N=FolderLegend
		ModifyGraph log=1	
	endif
	
	IF(cmpstr(ctrlName,"PlotBkg")==0)//dws
		setdatafolder BKGfolder
		Appendtograph BKGIntensityWave vs BKGQWave	
		list=TraceNameList("",";",1)
		NumberofWaves=ItemsInList(tracenamelist("",";",1))
		n=num2str(numpnts(BKGIntensityWave))
		print n
		execute("cursor b,"+Possiblyquotename(BKGIntensityWavename)+","+n)
		execute("cursor a,"+Possiblyquotename(BKGIntensityWavename)+","+n)		
	endif
	
	IF(cmpstr(ctrlName,"SubtractBkg")==0)//dws		
		 Setdatafolder Foldername		
		 	 newRwavename=foldername+rwavename+"W"	//for powerlaww subtraction
			duplicate/o $Rwavename,$newRwavename
			wave newrwave=$newRwavename
		newQwavename=foldername+Qwavename+"W"	//for powerlaww subtraction
			duplicate/o $Qwavename,$newQwavename
			wave newQwave=$newQwavename
		newSwavename=foldername+Swavename+"W"	//for powerlaww subtraction
			duplicate/o $Swavename,$newSwavename
			wave newSwave=$newSwavename
		//Rwave-=BKGIntensityWave
		NewRwave=Rwave-BKGIntensityWave
		appendtograph newrwave vs newqwave	
	endif
	
	IF(cmpstr(ctrlName,"Subtract")==0)//dws
	
		
		setdatafolder FolderName
		 newRwavename=foldername+rwavename+"B"	//for powerlaww subtraction
			duplicate/o $Rwavename,$newRwavename
			wave newrwave=$newRwavename
		 newQwavename=foldername+Qwavename+"B"	//for powerlaww subtraction
			duplicate/o $Qwavename,$newQwavename
			wave newQwave=$newQwavename
		 newSwavename=foldername+Swavename+"B"	//for powerlaww subtraction
			duplicate/o $Swavename,$newSwavename
			wave newSwave=$newSwavename
		NewRwave-=Data1_Background
		appendtograph newrwave vs newqwave
		wavenote="    ;BackgroundSubtracted="+num2str(Data1_Background)+";"	
		// cmd="Note "+possiblyquotename(NewRwaveName)+",\""+wavenote+"\""
		cmd="Note "+NewRwaveName+",\""+wavenote+"\""
		print cmd
		execute (cmd)
	endif
		
	IF(cmpstr(ctrlName,"LoadLQD")==0)//dws
		execute("load1dLANL_SANS()")
	endif	
end



Function DWS_setvarDataManip(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	string ,wavenote,cmd
	NVAR Data1_Background=root:Packages:SASDataModification:Data1_Background
	NVAR Data1_Thickness=root:Packages:SASDataModification:Data1_Thickness
	SVAR FolderName=root:Packages:SASDataModification:DataFolderName
	SVAR RWaveName=root:Packages:SASDataModification:IntensityWaveName
	wave RWave=$RWaveName
			setdatafolder FolderName
	
	if(cmpstr(ctrlName,"Data1_Background")==0)
		Rwave-=Data1_Background
		Wavenote="    ;BackgroundSubtracted="+num2str(Data1_Background)+";"	
		cmd="Note "+RWaveName+",\""+wavenote+"\""
		execute (cmd)
	endif 
	
	if(cmpstr(ctrlName,"Data1_Thickness")==0)		
		NVAR Thickness
		Thickness=Data1_Thickness
		Rwave/=Data1_Thickness	
		 Wavenote="    ;Thickness="+num2str(Data1_Thickness)+";"	
		cmd="Note "+RWaveName+",\""+wavenote+"\""
		execute (cmd)
	endif
	
	if(cmpstr(ctrlName,"qshift")==0)
		DWS_DataManipulationButtonProc("shifq")	
	endif
	
End
function StripQuoteFromQRSnames()
	SVAR Dtf=root:Packages:GeneralplottingTool:DataFolderName
		SVAR IntDf=root:Packages:GeneralplottingTool:IntensityWaveName
		SVAR QDf=root:Packages:GeneralplottingTool:QWaveName
		SVAR EDf=root:Packages:GeneralplottingTool:ErrorWaveName
		IntDf =ReplaceString("'", IntDf, "")
		QDf =ReplaceString("'", QDf, "")
		EDf =ReplaceString("'", EDf, "")
End


//function DWS_CreateGraph(new)
		variable new
		SVAR Dtf=root:Packages:GeneralplottingTool:DataFolderName
		SVAR IntDf=root:Packages:GeneralplottingTool:IntensityWaveName
		SVAR QDf=root:Packages:GeneralplottingTool:QWaveName
		SVAR EDf=root:Packages:GeneralplottingTool:ErrorWaveName
		SVAR ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
		variable lines, markers
		lines= NumberByKey("Graph use Lines", ListOfGraphFormating,"=",";")
		markers= NumberByKey("Graph use Symbols", ListOfGraphFormating,"=",";")
		setdatafolder Dtf
		StripQuoteFromQRSnames()
		
	if((new)||(cmpstr(WinList("*",";","WIN:1"), "" )==0))
		If(stringmatch (QDf,""))
			Display/N=GeneralGraph/K=1/W=(400,0,700,350 ) $IntDf as  "General Graph"
		Else
			Display/N=GeneralGraph/K=1/W=(400,0,700,350 ) $IntDf vs $QDf as  "General Graph"	
		endif		
		ModifyGraph grid=2,tick=2,minor=1,font="Times",zero(left)=1,standoff=0, mirror=1,tick=2,mirror=1,fStyle=1,fSize=12,standoff=0;DelayUpdate
		ModifyGraph axThick=2
		ShowInfo;ShowTools
			ModifyGraph log(bottom)=NumberByKey("log(bottom)", ListOfGraphFormating,"=",";")
		ModifyGraph log(left)=NumberByKey("log(left)", ListOfGraphFormating,"=",";")
		ModifyGraph axThick=NumberByKey("axthick", ListOfGraphFormating,"=",";")
		ModifyGraph msize=NumberByKey("msize", ListOfGraphFormating,"=",";")
		ModifyGraph lsize=NumberByKey("lsize", ListOfGraphFormating,"=",";")
	else
		If(stringmatch (QDf,""))
			AppendToGraph $IntDf
		else
			AppendToGraph $IntDf vs $QDf
		endif
	endif
	if (new)
		markers=0+ ((Lines==0)*(markers==1)*3)+((Lines==1)*(markers==1)*4)
	
		string tracelist, activetrace;variable total
		tracelist=TraceNameList("",";",1)
		total=ItemsInList(tracelist)
		activetrace =StringFromList(total-1, tracelist)
	//activetrace=TraceNameToWaveRef( "",activetrace )   ///actual wave name here
		ModifyGraph mode($activetrace)=markers
		DWS_FixAxesInGraph()
		formatgraph(1)
	endif
	if (NumberByKey("ErrorBars", ListOfGraphFormating,"=",";")==1)
		DWS_AttachErrorBars()
	endif
end


		

	DWS_AttachLegend()//NumberByKey("Legend",ListOfGraphFormating,"="))
	//DWS_AttachErrorBars()
	//DWS_FixAxesInGraph()
	variable mode=0
	if (markers)
		mode=3*markers+lines
	endif
	if ((markers!=0)||(lines!=0))
		ChangetoLineandPoints(mode,colors)
	endif

	
end


function DWS_AttachLegend()
	variable type;string size
	
		SVAR ListOfGraphFormating=root:Packages:Irena:DWSplottingTool:ListOfGraphFormating
	size=StringByKey("Graph legend Size",ListOfGraphFormating,"=")
	Type=NumberByKey("Legend",ListOfGraphFormating,"=")
	variable NumberofWaves=ItemsInList(tracenamelist("",";",1))
	variable counter=0
	string theFolder,TheText, TheText2
	string list=TraceNameList("",";",1)
	theText="\Z"+size
	theText2=theText
	if ((type==2) ||(type==4))
		do
	string tracename=StringFromList(counter, list,";")//getstrfromlist (list, counter,";")
	
			theFolder=GetWavesDataFolder(WaveRefIndexed("",counter ,1),0)
			theText=theText+ "\r\s("+tracename+")"
			theText=theText+thefolder//theFolder[0,(strlen(theFolder)-0)]
			counter+=1
		while(counter<Numberofwaves)
		TextBox/C/A=RT/N=FolderLegend theText	
	endif	
	
	counter=0
	IF ((type==3)||(type==4))
		do
			tracename= StringFromList(counter, list,";")//getstrfromlist (list, counter,";")
			theText2=theText2+ "\r\s("+tracename+")"
			theText2=theText2+tracename
			counter+=1
		while(counter<Numberofwaves)
		TextBox/C/A=RB/N=WaveLegend theText2	
	endif	
		
End



Function DWS_FixAxesInGraph()//keep

	NVAR GraphLeftAxisAuto=root:Packages:GeneralplottingTool:GraphLeftAxisAuto
	NVAR GraphLeftAxisMin=root:Packages:GeneralplottingTool:GraphLeftAxisMin
	NVAR GraphLeftAxisMax=root:Packages:GeneralplottingTool:GraphLeftAxisMax
	NVAR GraphBottomAxisAuto=root:Packages:GeneralplottingTool:GraphBottomAxisAuto
	NVAR GraphBottomAxisMin=root:Packages:GeneralplottingTool:GraphBottomAxisMin
	NVAR GraphBottomAxisMax=root:Packages:GeneralplottingTool:GraphBottomAxisMax
	SVAR ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
		GetAxis/Q left
		if (V_Flag)
			abort
		endif
	
	if (GraphLeftAxisAuto)	//autoscale left axis
		SetAxis/A left
		DoUpdate
		GetAxis /Q left
		GraphLeftAxisMin=V_min
		GraphLeftAxisMax=V_max
		ListOfGraphFormating=ReplaceNumberByKey("Axis left min",ListOfGraphFormating, GraphLeftAxisMin,"=")
		ListOfGraphFormating=ReplaceNumberByKey("Axis left max",ListOfGraphFormating, GraphLeftAxisMax,"=")

	else		//fixed left axis
		SetAxis left GraphLeftAxisMin,GraphLeftAxisMax

	endif
	
	if (GraphBottomAxisAuto)	//autoscale bottom axis
		SetAxis/A bottom
		DoUpdate
		GetAxis  /Q bottom
		GraphBottomAxisMin=V_min
		GraphBottomAxisMax=V_max
		ListOfGraphFormating=ReplaceNumberByKey("Axis bottom min",ListOfGraphFormating, GraphBottomAxisMin,"=")
		ListOfGraphFormating=ReplaceNumberByKey("Axis bottom max",ListOfGraphFormating, GraphBottomAxisMax,"=")
	else		//fixed bottom axis
		SetAxis bottom GraphBottomAxisMin,GraphBottomAxisMax

	endif
end



Function MoveSelectionTools(XPOS, YPOS)//works with IR2C_AddDataControls
	Variable XPOS, YPOS
	String Checkboxes=ControlNameList("", ";" ,"Use*")
	print checkboxes
	IF(-1!=strsearch(checkboxes, "UseQRSData",0,2))
		CheckBox UseQRSData pos={XPOS,YPOS}
	Elseif(-1!=strsearch(checkboxes, "UseIndra2Data",0,2))
		CheckBox UseIndra2Data pos={XPOS,YPOS+13}
	Elseif(-1!=strsearch(checkboxes, "UseResults",0,2))
		CheckBox UseResults pos={XPOS+100,YPOS}
	elseif (-1!=strsearch(checkboxes, "UseUserDefinedData",0,2))
		CheckBox UseUserDefinedData pos={XPOS+100,YPOS+13}
	endif
	YPOS=YPOS+5
	PopupMenu SelectDataFolder pos={XPOS,YPOS+23}
	PopupMenu IntensityDataName pos={XPOS,YPOS+73}
	PopupMenu QvecDataName pos={XPOS,YPOS+48}
	PopupMenu ErrorDataName pos={XPOS,YPOS+98}	
	PopupMenu QvecDataName title="X Wave"
	PopupMenu IntensityDataName title="Y Wave"
	PopupMenu ErrorDataName title="S Wave"
	PopupMenu SelectDataFolder title="Folder"
end

